<?php
$_['opencart_version'] = array(
    "2.0.0.0",
    "2.0.1.0",
    "2.0.1.1",
    "2.0.2.0",
    "2.0.3.1",
    "2.1.0.1",
    "2.1.0.2",
    "2.2.0.0",
    "2.3.0.0",
    "2.3.0.1",
    "2.3.0.2");
$_['main_sheet'] = array(
    'name' => 'Customers',
    'table' => array(
        'name' => 'c',
        'full_name' => 'customer',
        'key' => 'customer_id'
        ),

    'tables' => array(),

    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'c',
            'name' => 'Customer ID',
            'filter' => 1
            ),
        array(
            'column' => 'firstname',
            'table' => 'c',
            'name' => 'First Name',
            'filter' => 1
            ),
        array(
            'column' => 'lastname',
            'table' => 'c',
            'name' => 'Last Name',
            'filter' => 1
            ),
        array(
            'column' => 'email',
            'table' => 'c',
            'name' => 'E-Mail',
            'filter' => 1
            ),
        array(
            'column' => 'telephone',
            'table' => 'c',
            'name' => 'Telephone',
            'filter' => 1
            ),
        array(
            'column' => 'fax',
            'table' => 'c',
            'name' => 'Fax',
            'filter' => 1
            ),
        array(
            'column' => 'password',
            'table' => 'c',
            'name' => 'Password'

            ),
        array(
            'column' => 'salt',
            'table' => 'c',
            'name' => 'Salt'
            ),
        array(
            'column' => 'newsletter',
            'table' => 'c',
            'name' => 'Newsletter',
            'filter' => 1
            ),
        array(
            'column' => 'status',
            'table' => 'c',
            'name' => 'Status',
            'filter' => 1
            ),
        array(
            'column' => 'approved',
            'table' => 'c',
            'name' => 'Approved'
            ),
        array(
            'column' => 'customer_group_id',
            'table' => 'c',
            'name' => 'Customer Group ID',
            'filter' => 1
            ),
        array(
            'column' => 'address_id',
            'table' => 'c',
            'name' => 'Address ID',
            'filter' => 1
            ),
        array(
            'column' => 'cart',
            'table' => 'c',
            'name' => 'Cart'
            ),
        array(
            'column' => 'wishlist',
            'table' => 'c',
            'name' => 'Wishlist'
            ),
        array(
            'column' => 'safe',
            'table' => 'c',
            'name' => 'Safe'
            ),
        
        )
    );

$_['sheets'] = array(
    array(
    'name' => 'Addresses',
    'table' => array(
        'name' => 'a',
        'full_name' => 'address',
        'related_key' => 'customer_id',
        'key' => 'address_id'
        ),
    'tables' => array(),
    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'a',
            'name' => 'Customer ID'
            ),
        array(
            'column' => 'address_id',
            'table' => 'a',
            'name' => 'Address ID'
            ),
        array(
            'column' => 'firstname',
            'table' => 'a',
            'name' => 'First Name'
            ),
        array(
            'column' => 'lastname',
            'table' => 'a',
            'name' => 'Last Name'
            ),
        array(
            'column' => 'company',
            'table' => 'a',
            'name' => 'Company'
            ),
        array(
            'column' => 'address_1',
            'table' => 'a',
            'name' => 'Address 1'
            ),
        array(
            'column' => 'address_2',
            'table' => 'a',
            'name' => 'Address 2'
            ),
        array(
            'column' => 'city',
            'table' => 'a',
            'name' => 'City'
            ),
        array(
            'column' => 'postcode',
            'table' => 'a',
            'name' => 'Post Code'
            ),
        array(
            'column' => 'country_id',
            'table' => 'a',
            'name' => 'Country ID'
            ),
        array(
            'column' => 'zone_id',
            'table' => 'a',
            'name' => 'Zone ID'
            ),
        array(
            'column' => 'custom_field',
            'table' => 'a',
            'name' => 'Custom Field'
            )
        )
    ),
    array(
    'name' => 'History',
    'table' => array(
        'name' => 'ch',
        'full_name' => 'customer_history',
        'related_key' => 'customer_id',
        'key' => 'customer_history_id'
        ),
    'tables' => array(),
    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'ch',
            'name' => 'Customer ID'
            ),
        array(
            'column' => 'comment',
            'table' => 'ch',
            'name' => 'Comment'
            ),
        array(
            'column' => 'date_added',
            'table' => 'ch',
            'name' => 'Date Added'
            )
        )
    ),
    array(
    'name' => 'Transactions',
    'table' => array(
        'name' => 'ct',
        'full_name' => 'customer_transaction',
        'related_key' => 'customer_id',
        'key' => 'customer_transaction_id'
        ),
    'tables' => array(),
    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'ct',
            'name' => 'Customer ID'
            ),
        array(
            'column' => 'order_id',
            'table' => 'ct',
            'name' => 'Order ID'
            ),
        array(
            'column' => 'description',
            'table' => 'ct',
            'name' => 'Description'
            ),
        array(
            'column' => 'amount',
            'table' => 'ct',
            'name' => 'Amount'
            )
        )
    ),
    array(
    'name' => 'Reward Points',
    'table' => array(
        'name' => 'cr',
        'full_name' => 'customer_reward',
        'related_key' => 'customer_id',
        'key' => 'customer_reward_id'
        ),
    'tables' => array(),
    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'cr',
            'name' => 'Customer ID'
            ),
        array(
            'column' => 'order_id',
            'table' => 'cr',
            'name' => 'Order ID'
            ),
        array(
            'column' => 'description',
            'table' => 'cr',
            'name' => 'Description'
            ),
        array(
            'column' => 'points',
            'table' => 'cr',
            'name' => 'Points'
            ),
        array(
            'column' => 'date_added',
            'table' => 'cr',
            'name' => 'Date Added'
            )
        )
    ),
    array(
    'name' => 'IP Addresses',
    'table' => array(
        'name' => 'ci',
        'full_name' => 'customer_ip',
        'related_key' => 'customer_id',
        'key' => 'customer_ip_id'
        ),
    'tables' => array(),
    'columns' => array(
        array(
            'column' => 'customer_id',
            'table' => 'ci',
            'name' => 'Customer ID'
            ),
        array(
            'column' => 'ip',
            'table' => 'ci',
            'name' => 'IP'
            ),
        array(
            'column' => 'date_added',
            'table' => 'ci',
            'name' => 'Date Added'
            )
        )
    )
);
